#!/bin/bash

export LOAD_LOC=`pwd`
export THIRDLANE_VERSION=1.8

INSTYPE=$1
export INSTYPE

if [ "$INSTYPE" = "ast18st" -o "$INSTYPE" = "ast18mt" -o "$INSTYPE" = "ast18cst" -o "$INSTYPE" = "ast18cmt" -o "$INSTYPE" = "ast13st" -o "$INSTYPE" = "ast13mt" ]
then 
    echo "*** INSTYPE=$INSTYPE ***"
    echo 
else
    echo "Usage: install_parts.sh pbxtype"
    echo "  pbxtype=ast18st for Asterisk 1.8 and PBX Manager ST"
    echo "  pbxtype=ast18mt for Asterisk 1.8 and PBX Manager MT"
    echo "  pbxtype=ast18cst for Certified Asterisk 1.8 and PBX Manager ST"
    echo "  pbxtype=ast18cmt for Certified Asterisk 1.8 and PBX Manager MT"
    echo "  pbxtype=ast13st for Asterisk 13 and PBX Manager ST"
    echo "  pbxtype=ast13mt for Asterisk 13 and PBX Manager MT"
    exit 1
fi

#WBMTYPE=`echo $PBXTYPE | awk '{print (substr($1,6,2))}'`
#PBXTYPE=`echo $PBXTYPE | awk '{print (substr($1,1,5))}'`

if [ "$INSTYPE" = "ast18st" -o "$INSTYPE" = "ast18cst"  -o "$INSTYPE" = "ast13st" ];  then WBMTYPE=st; fi
if [ "$INSTYPE" = "ast18mt" -o "$INSTYPE" = "ast18cmt"  -o "$INSTYPE" = "ast13mt" ];  then WBMTYPE=mt; fi

if [ "$INSTYPE" = "ast18st" -o "$INSTYPE" = "ast18mt" ];   then PBXTYPE=ast18; fi
if [ "$INSTYPE" = "ast18cst" -o "$INSTYPE" = "ast18cmt" ]; then PBXTYPE=ast18c; fi
if [ "$INSTYPE" = "ast13st" -o "$INSTYPE" = "ast13mt" ];   then PBXTYPE=ast13; fi

export PBXTYPE
export WBMTYPE

date
echo PBXTYPE=$PBXTYPE WBMTYPE=$WBMTYPE

cd $LOAD_LOC
scripts=`ls -1 firstboot/* | sort -n`

if [ "$WORKER" = "yes" ]; then
    list="01prereq 02syslog-ng 03iptables 06asterisk 07memcached 08postfix 14logrotate 70upgrade"
    scripts=""
    for a in `echo $list`; do scripts="$scripts firstboot/$a"; done
fi

for firstboot_script in `echo $scripts`; do
	echo
	echo `date` " --- Running ${firstboot_script}... ---"
	time bash  ./${firstboot_script} 2>&1
done


echo
echo "*** PBX Manager Installation finished... ***"
echo
date
echo 
killall -9 tee
