/*
 * Decompiled with CFR 0.152.
 */
package com.thirdlane.applet;

public class RC4 {
    private byte[] state = new byte[256];
    private int x;
    private int y;

    public RC4(String key) throws NullPointerException {
        this(key.getBytes());
    }

    public RC4(byte[] key) throws NullPointerException {
        for (int i = 0; i < 256; ++i) {
            this.state[i] = (byte)i;
        }
        this.x = 0;
        this.y = 0;
        int index1 = 0;
        int index2 = 0;
        if (key == null || key.length == 0) {
            throw new NullPointerException();
        }
        for (int i = 0; i < 256; ++i) {
            index2 = (key[index1] & 0xFF) + (this.state[i] & 0xFF) + index2 & 0xFF;
            byte tmp = this.state[i];
            this.state[i] = this.state[index2];
            this.state[index2] = tmp;
            index1 = (index1 + 1) % key.length;
        }
    }

    public byte[] rc4(String data) {
        if (data == null) {
            return null;
        }
        byte[] tmp = data.getBytes();
        return this.rc4(tmp);
    }

    public byte[] rc4(byte[] buf) {
        if (buf == null) {
            return null;
        }
        byte[] result = new byte[buf.length];
        for (int i = 0; i < buf.length; ++i) {
            this.x = this.x + 1 & 0xFF;
            this.y = (this.state[this.x] & 0xFF) + this.y & 0xFF;
            byte tmp = this.state[this.x];
            this.state[this.x] = this.state[this.y];
            this.state[this.y] = tmp;
            int xorIndex = (this.state[this.x] & 0xFF) + (this.state[this.y] & 0xFF) & 0xFF;
            result[i] = (byte)(buf[i] ^ this.state[xorIndex]);
        }
        return result;
    }
}

