/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.AuthenticationFailedException;
import org.asteriskjava.manager.EventTimeoutException;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.ManagerEventListener;
import org.asteriskjava.manager.ResponseEvents;
import org.asteriskjava.manager.SendActionCallback;
import org.asteriskjava.manager.TimeoutException;
import org.asteriskjava.manager.action.ChallengeAction;
import org.asteriskjava.manager.action.CommandAction;
import org.asteriskjava.manager.action.EventGeneratingAction;
import org.asteriskjava.manager.action.LoginAction;
import org.asteriskjava.manager.action.LogoffAction;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.ConnectEvent;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ManagerReaderImpl;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.internal.ManagerWriter;
import org.asteriskjava.manager.internal.ManagerWriterImpl;
import org.asteriskjava.manager.internal.ResponseEventsImpl;
import org.asteriskjava.manager.response.ChallengeResponse;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerError;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;
import org.asteriskjava.util.internal.SocketConnectionFacadeImpl;

public class ManagerConnectionImpl
implements ManagerConnection,
Dispatcher {
    private static final int RECONNECTION_INTERVAL_1 = 50;
    private static final int RECONNECTION_INTERVAL_2 = 5000;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private static final int DEFAULT_PORT = 5038;
    private static final int RECONNECTION_VERSION_INTERVAL = 500;
    private static final int MAX_VERSION_ATTEMPTS = 4;
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final long id;
    private AtomicLong actionIdCounter = new AtomicLong(0L);
    private String hostname = "localhost";
    private int port = 5038;
    private boolean ssl = false;
    protected String username;
    protected String password;
    private long defaultResponseTimeout = 2000L;
    private long defaultEventTimeout = 5000L;
    private int socketTimeout = 0;
    private int socketReadTimeout = 0;
    private boolean keepAliveAfterAuthenticationFailure = true;
    private SocketConnectionFacade socket;
    private Thread readerThread;
    private final AtomicLong readerThreadCounter = new AtomicLong(0L);
    private Thread reconnectThread;
    private final AtomicLong reconnectThreadCounter = new AtomicLong(0L);
    private ManagerReader reader;
    private ManagerWriter writer;
    private final ProtocolIdentifierWrapper protocolIdentifier;
    private AsteriskVersion version;
    private final Map<String, SendActionCallback> responseListeners;
    private final Map<String, ManagerEventListener> responseEventListeners;
    private final List<ManagerEventListener> eventListeners;
    private boolean reconnecting = false;
    protected ManagerConnectionState state = ManagerConnectionState.INITIAL;
    private String eventMask;

    public ManagerConnectionImpl() {
        this.id = idCounter.getAndIncrement();
        this.responseListeners = new HashMap<String, SendActionCallback>();
        this.responseEventListeners = new HashMap<String, ManagerEventListener>();
        this.eventListeners = new ArrayList<ManagerEventListener>();
        this.protocolIdentifier = new ProtocolIdentifierWrapper();
    }

    protected ManagerReader createReader(Dispatcher dispatcher, Object object) {
        return new ManagerReaderImpl(dispatcher, object);
    }

    protected ManagerWriter createWriter() {
        return new ManagerWriterImpl();
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public void setPort(int n) {
        this.port = n <= 0 ? 5038 : n;
    }

    public void setSsl(boolean bl) {
        this.ssl = bl;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setDefaultResponseTimeout(long l) {
        this.defaultResponseTimeout = l;
    }

    public void setDefaultEventTimeout(long l) {
        this.defaultEventTimeout = l;
    }

    public void setKeepAliveAfterAuthenticationFailure(boolean bl) {
        this.keepAliveAfterAuthenticationFailure = bl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void registerUserEventClass(Class clazz) {
        if (this.reader == null) {
            this.reader = this.createReader(this, this);
        }
        this.reader.registerEventClass(clazz);
    }

    public void setSocketTimeout(int n) {
        this.socketTimeout = n;
    }

    public void setSocketReadTimeout(int n) {
        this.socketReadTimeout = n;
    }

    public synchronized void login() throws IOException, AuthenticationFailedException, TimeoutException {
        this.login(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void login(String string) throws IOException, AuthenticationFailedException, TimeoutException {
        if (this.state != ManagerConnectionState.INITIAL && this.state != ManagerConnectionState.DISCONNECTED) {
            throw new IllegalStateException("Login may only be perfomed when in state INITIAL or DISCONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.CONNECTING;
        this.eventMask = string;
        try {
            this.doLogin(this.defaultResponseTimeout, string);
        }
        finally {
            if (this.state != ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.DISCONNECTED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void doLogin(long l, String string) throws IOException, AuthenticationFailedException, TimeoutException {
        ManagerResponse managerResponse;
        String string2;
        ManagerResponse managerResponse2;
        if (this.socket == null) {
            this.connect();
        }
        Object object = this.protocolIdentifier;
        synchronized (object) {
            if (this.protocolIdentifier.value == null) {
                try {
                    this.protocolIdentifier.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.protocolIdentifier.value == null) {
                this.disconnect();
                if (this.reader != null && this.reader.getTerminationException() != null) {
                    throw this.reader.getTerminationException();
                }
                throw new TimeoutException("Timeout waiting for protocol identifier");
            }
        }
        ChallengeAction challengeAction = new ChallengeAction("MD5");
        try {
            managerResponse2 = this.sendAction(challengeAction);
        }
        catch (Exception exception) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send challenge action", exception);
        }
        if (!(managerResponse2 instanceof ChallengeResponse)) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to get challenge from Asterisk. ChallengeAction returned: " + managerResponse2.getMessage());
        }
        String string3 = ((ChallengeResponse)managerResponse2).getChallenge();
        try {
            object = MessageDigest.getInstance("MD5");
            if (string3 != null) {
                ((MessageDigest)object).update(string3.getBytes());
            }
            if (this.password != null) {
                ((MessageDigest)object).update(this.password.getBytes());
            }
            string2 = ManagerUtil.toHexString(((MessageDigest)object).digest());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to create login key using MD5 Message Digest", noSuchAlgorithmException);
        }
        LoginAction loginAction = new LoginAction(this.username, "MD5", string2, string);
        try {
            managerResponse = this.sendAction(loginAction);
        }
        catch (Exception exception) {
            this.disconnect();
            throw new AuthenticationFailedException("Unable to send login action", exception);
        }
        if (managerResponse instanceof ManagerError) {
            this.disconnect();
            throw new AuthenticationFailedException(managerResponse.getMessage());
        }
        this.state = ManagerConnectionState.CONNECTED;
        this.logger.info("Successfully logged in");
        this.version = this.determineVersion();
        this.writer.setTargetVersion(this.version);
        this.logger.info("Determined Asterisk version: " + this.version);
        object = new ConnectEvent(this);
        ((ConnectEvent)object).setProtocolIdentifier(this.getProtocolIdentifier());
        ((ManagerEvent)object).setDateReceived(DateUtil.getDate());
        this.fireEvent((ManagerEvent)object);
    }

    protected AsteriskVersion determineVersion() throws IOException, TimeoutException {
        int n = 0;
        while (n < 4) {
            List<String> list;
            ManagerResponse managerResponse = this.sendAction((ManagerAction)new CommandAction("show version files pbx.c"), this.defaultResponseTimeout * 2L);
            if (!(managerResponse instanceof CommandResponse) || (list = ((CommandResponse)managerResponse).getResult()) == null || list.size() <= 0) continue;
            String string = list.get(0);
            if (string != null && string.startsWith("File")) {
                String string2 = this.getRawVersion();
                if (string2 != null && string2.startsWith("Asterisk 1.4")) {
                    return AsteriskVersion.ASTERISK_1_4;
                }
                return AsteriskVersion.ASTERISK_1_2;
            }
            if (string == null || !string.contains("No such command")) break;
            try {
                ++n;
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
        return AsteriskVersion.ASTERISK_1_0;
    }

    protected String getRawVersion() {
        List<String> list;
        ManagerResponse managerResponse;
        try {
            managerResponse = this.sendAction((ManagerAction)new CommandAction("show version"), this.defaultResponseTimeout * 2L);
        }
        catch (Exception exception) {
            return null;
        }
        if (managerResponse instanceof CommandResponse && (list = ((CommandResponse)managerResponse).getResult()) != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    protected synchronized void connect() throws IOException {
        this.logger.info("Connecting to " + this.hostname + ":" + this.port);
        if (this.reader == null) {
            this.logger.debug("Creating reader for " + this.hostname + ":" + this.port);
            this.reader = this.createReader(this, this);
        }
        if (this.writer == null) {
            this.logger.debug("Creating writer");
            this.writer = this.createWriter();
        }
        this.logger.debug("Creating socket");
        this.socket = this.createSocket();
        this.logger.debug("Passing socket to reader");
        this.reader.setSocket(this.socket);
        if (this.readerThread == null || !this.readerThread.isAlive() || this.reader.isDead()) {
            this.logger.debug("Creating and starting reader thread");
            this.readerThread = new Thread(this.reader);
            this.readerThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reader-" + this.readerThreadCounter.getAndIncrement());
            this.readerThread.setDaemon(true);
            this.readerThread.start();
        }
        this.logger.debug("Passing socket to writer");
        this.writer.setSocket(this.socket);
    }

    protected SocketConnectionFacade createSocket() throws IOException {
        return new SocketConnectionFacadeImpl(this.hostname, this.port, this.ssl, this.socketTimeout, this.socketReadTimeout);
    }

    public synchronized void logoff() throws IllegalStateException {
        if (this.state != ManagerConnectionState.CONNECTED && this.state != ManagerConnectionState.RECONNECTING) {
            throw new IllegalStateException("Logoff may only be perfomed when in state CONNECTED or RECONNECTING, but connection is in state " + (Object)((Object)this.state));
        }
        this.state = ManagerConnectionState.DISCONNECTING;
        if (this.socket != null && !this.reconnecting) {
            try {
                this.sendAction(new LogoffAction());
            }
            catch (Exception exception) {
                this.logger.warn("Unable to send LogOff action", exception);
            }
        }
        this.cleanup();
        this.state = ManagerConnectionState.DISCONNECTED;
    }

    protected synchronized void disconnect() {
        if (this.socket != null) {
            this.logger.info("Closing socket.");
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                this.logger.warn("Unable to close socket: " + iOException.getMessage());
            }
            this.socket = null;
        }
        this.protocolIdentifier.value = null;
    }

    public ManagerResponse sendAction(ManagerAction managerAction) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendAction(managerAction, this.defaultResponseTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ManagerResponse sendAction(ManagerAction managerAction, long l) throws IOException, TimeoutException, IllegalArgumentException, IllegalStateException {
        ResponseHandlerResult responseHandlerResult = new ResponseHandlerResult();
        DefaultSendActionCallback defaultSendActionCallback = new DefaultSendActionCallback(responseHandlerResult);
        ResponseHandlerResult responseHandlerResult2 = responseHandlerResult;
        synchronized (responseHandlerResult2) {
            this.sendAction(managerAction, defaultSendActionCallback);
            if (managerAction instanceof UserEventAction) {
                return null;
            }
            if (responseHandlerResult.getResponse() == null) {
                try {
                    responseHandlerResult.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.warn("Interrupted while waiting for result");
                }
            }
        }
        if (responseHandlerResult.getResponse() == null) {
            throw new TimeoutException("Timeout waiting for response to " + managerAction.getAction() + (managerAction.getActionId() == null ? "" : " (actionId: " + managerAction.getActionId() + ")"));
        }
        return responseHandlerResult.getResponse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAction(ManagerAction managerAction, SendActionCallback sendActionCallback) throws IOException, IllegalArgumentException, IllegalStateException {
        if (managerAction == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (!((this.state == ManagerConnectionState.CONNECTING || this.state == ManagerConnectionState.RECONNECTING) && (managerAction instanceof ChallengeAction || managerAction instanceof LoginAction) || this.state == ManagerConnectionState.DISCONNECTING && managerAction instanceof LogoffAction || this.state == ManagerConnectionState.CONNECTED)) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        if (this.socket == null) {
            throw new IllegalStateException("Unable to send " + managerAction.getAction() + " action: socket not connected.");
        }
        String string = this.createInternalActionId();
        if (sendActionCallback != null) {
            Map<String, SendActionCallback> map = this.responseListeners;
            synchronized (map) {
                this.responseListeners.put(string, sendActionCallback);
            }
        }
        this.writer.sendAction(managerAction, string);
    }

    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction eventGeneratingAction) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        return this.sendEventGeneratingAction(eventGeneratingAction, this.defaultEventTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseEvents sendEventGeneratingAction(EventGeneratingAction eventGeneratingAction, long l) throws IOException, EventTimeoutException, IllegalArgumentException, IllegalStateException {
        if (eventGeneratingAction == null) {
            throw new IllegalArgumentException("Unable to send action: action is null.");
        }
        if (eventGeneratingAction.getActionCompleteEventClass() == null) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass for " + eventGeneratingAction.getClass().getName() + " is null.");
        }
        if (!ResponseEvent.class.isAssignableFrom(eventGeneratingAction.getActionCompleteEventClass())) {
            throw new IllegalArgumentException("Unable to send action: actionCompleteEventClass (" + eventGeneratingAction.getActionCompleteEventClass().getName() + ") for " + eventGeneratingAction.getClass().getName() + " is not a ResponseEvent.");
        }
        if (this.state != ManagerConnectionState.CONNECTED) {
            throw new IllegalStateException("Actions may only be sent when in state CONNECTED, but connection is in state " + (Object)((Object)this.state));
        }
        ResponseEventsImpl responseEventsImpl = new ResponseEventsImpl();
        ResponseEventHandler responseEventHandler = new ResponseEventHandler(responseEventsImpl, eventGeneratingAction.getActionCompleteEventClass());
        String string = this.createInternalActionId();
        Map<String, ManagerEventListener> map = this.responseListeners;
        synchronized (map) {
            this.responseListeners.put(string, responseEventHandler);
        }
        map = this.responseEventListeners;
        synchronized (map) {
            this.responseEventListeners.put(string, responseEventHandler);
        }
        map = responseEventsImpl;
        synchronized (map) {
            this.writer.sendAction(eventGeneratingAction, string);
            if (responseEventsImpl.getResponse() == null || !responseEventsImpl.isComplete()) {
                try {
                    responseEventsImpl.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    this.logger.warn("Interrupted while waiting for response events.");
                }
            }
        }
        if (responseEventsImpl.getResponse() == null || !responseEventsImpl.isComplete()) {
            map = this.responseEventListeners;
            synchronized (map) {
                this.responseEventListeners.remove(string);
            }
            throw new EventTimeoutException("Timeout waiting for response or response events to " + eventGeneratingAction.getAction() + (eventGeneratingAction.getActionId() == null ? "" : " (actionId: " + eventGeneratingAction.getActionId() + ")"), responseEventsImpl);
        }
        map = this.responseEventListeners;
        synchronized (map) {
            this.responseEventListeners.remove(string);
        }
        return responseEventsImpl;
    }

    private String createInternalActionId() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hashCode());
        stringBuffer.append("_");
        stringBuffer.append(this.actionIdCounter.getAndIncrement());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(ManagerEventListener managerEventListener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (!this.eventListeners.contains(managerEventListener)) {
                this.eventListeners.add(managerEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(ManagerEventListener managerEventListener) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            if (this.eventListeners.contains(managerEventListener)) {
                this.eventListeners.remove(managerEventListener);
            }
        }
    }

    public String getProtocolIdentifier() {
        return this.protocolIdentifier.value;
    }

    public ManagerConnectionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchResponse(ManagerResponse managerResponse) {
        if (managerResponse == null) {
            this.logger.error("Unable to dispatch null response. This should never happen. Please file a bug.");
            return;
        }
        String string = managerResponse.getActionId();
        String string2 = null;
        SendActionCallback sendActionCallback = null;
        if (string != null) {
            string2 = ManagerUtil.getInternalActionId(string);
            managerResponse.setActionId(ManagerUtil.stripInternalActionId(string));
        }
        this.logger.debug("Dispatching response with internalActionId '" + string2 + "':\n" + managerResponse);
        if (string2 != null) {
            Map<String, SendActionCallback> map = this.responseListeners;
            synchronized (map) {
                sendActionCallback = this.responseListeners.get(string2);
                if (sendActionCallback != null) {
                    this.responseListeners.remove(string2);
                } else {
                    this.logger.debug("No response listener registered for internalActionId '" + string2 + "'");
                }
            }
        } else {
            this.logger.error("Unable to retrieve internalActionId from response: actionId '" + string + "':\n" + managerResponse);
        }
        if (sendActionCallback != null) {
            try {
                sendActionCallback.onResponse(managerResponse);
            }
            catch (Exception exception) {
                this.logger.warn("Unexpected exception in response listener " + sendActionCallback.getClass().getName(), exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchEvent(ManagerEvent managerEvent) {
        ManagerEvent managerEvent2;
        String string;
        if (managerEvent == null) {
            this.logger.error("Unable to dispatch null event. This should never happen. Please file a bug.");
            return;
        }
        this.logger.debug("Dispatching event:\n" + managerEvent.toString());
        if (managerEvent instanceof ResponseEvent && (string = ((ResponseEvent)(managerEvent2 = (ResponseEvent)managerEvent)).getInternalActionId()) != null) {
            Map<String, ManagerEventListener> map = this.responseEventListeners;
            synchronized (map) {
                ManagerEventListener managerEventListener = this.responseEventListeners.get(string);
                if (managerEventListener != null) {
                    try {
                        managerEventListener.onManagerEvent(managerEvent);
                    }
                    catch (Exception exception) {
                        this.logger.warn("Unexpected exception in response event listener " + managerEventListener.getClass().getName(), exception);
                    }
                }
            }
        }
        if (managerEvent instanceof DisconnectEvent) {
            if (this.state == ManagerConnectionState.CONNECTED) {
                this.state = ManagerConnectionState.RECONNECTING;
                this.cleanup();
                this.reconnectThread = new Thread(new Runnable(){

                    public void run() {
                        ManagerConnectionImpl.this.reconnect();
                    }
                });
                this.reconnectThread.setName("Asterisk-Java ManagerConnection-" + this.id + "-Reconnect-" + this.reconnectThreadCounter.getAndIncrement());
                this.reconnectThread.setDaemon(true);
                this.reconnectThread.start();
            } else {
                return;
            }
        }
        if (managerEvent instanceof ProtocolIdentifierReceivedEvent) {
            managerEvent2 = (ProtocolIdentifierReceivedEvent)managerEvent;
            string = ((ProtocolIdentifierReceivedEvent)managerEvent2).getProtocolIdentifier();
            this.setProtocolIdentifier(string);
            return;
        }
        this.fireEvent(managerEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(ManagerEvent managerEvent) {
        List<ManagerEventListener> list = this.eventListeners;
        synchronized (list) {
            for (ManagerEventListener managerEventListener : this.eventListeners) {
                try {
                    managerEventListener.onManagerEvent(managerEvent);
                }
                catch (RuntimeException runtimeException) {
                    this.logger.warn("Unexpected exception in eventHandler " + managerEventListener.getClass().getName(), runtimeException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProtocolIdentifier(String string) {
        this.logger.info("Connected via " + string);
        if (!("Asterisk Call Manager/1.0".equals(string) || "Asterisk Call Manager/1.2".equals(string) || "OpenPBX Call Manager/1.0".equals(string) || "CallWeaver Call Manager/1.0".equals(string))) {
            this.logger.warn("Unsupported protocol version '" + string + "'. Use at your own risk.");
        }
        ProtocolIdentifierWrapper protocolIdentifierWrapper = this.protocolIdentifier;
        synchronized (protocolIdentifierWrapper) {
            this.protocolIdentifier.value = string;
            this.protocolIdentifier.notify();
        }
    }

    private void reconnect() {
        int n = 0;
        while (this.state == ManagerConnectionState.RECONNECTING) {
            try {
                if (n < 10) {
                    Thread.sleep(50L);
                } else {
                    Thread.sleep(5000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                this.connect();
                try {
                    this.doLogin(this.defaultResponseTimeout, this.eventMask);
                    this.logger.info("Successfully reconnected.");
                    break;
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    if (this.keepAliveAfterAuthenticationFailure) {
                        this.logger.error("Unable to log in after reconnect: " + authenticationFailedException.getMessage());
                    } else {
                        this.logger.error("Unable to log in after reconnect: " + authenticationFailedException.getMessage() + ". Giving up.");
                        this.state = ManagerConnectionState.DISCONNECTED;
                    }
                }
                catch (TimeoutException timeoutException) {
                    this.logger.error("TimeoutException while trying to log in after reconnect.");
                }
            }
            catch (IOException iOException) {
                this.logger.warn("Exception while trying to reconnect: " + iOException.getMessage());
            }
            ++n;
        }
    }

    private void cleanup() {
        this.disconnect();
        this.readerThread = null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ManagerConnection[");
        stringBuffer.append("id='").append(this.id).append("',");
        stringBuffer.append("hostname='").append(this.hostname).append("',");
        stringBuffer.append("port=").append(this.port).append(",");
        stringBuffer.append("systemHashcode=").append(System.identityHashCode(this)).append("]");
        return stringBuffer.toString();
    }

    private class ProtocolIdentifierWrapper {
        String value;

        private ProtocolIdentifierWrapper() {
        }
    }

    private class ResponseEventHandler
    implements ManagerEventListener,
    SendActionCallback,
    Serializable {
        private static final long serialVersionUID = 2926598671855316803L;
        private final ResponseEventsImpl events;
        private final Class actionCompleteEventClass;

        public ResponseEventHandler(ResponseEventsImpl responseEventsImpl, Class clazz) {
            this.events = responseEventsImpl;
            this.actionCompleteEventClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onManagerEvent(ManagerEvent managerEvent) {
            ResponseEventsImpl responseEventsImpl = this.events;
            synchronized (responseEventsImpl) {
                if (managerEvent instanceof ResponseEvent) {
                    ResponseEvent responseEvent = (ResponseEvent)managerEvent;
                    this.events.addEvent(responseEvent);
                }
                if (this.actionCompleteEventClass.isAssignableFrom(managerEvent.getClass())) {
                    this.events.setComplete(true);
                    if (this.events.getResponse() != null) {
                        this.events.notify();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(ManagerResponse managerResponse) {
            ResponseEventsImpl responseEventsImpl = this.events;
            synchronized (responseEventsImpl) {
                this.events.setRepsonse(managerResponse);
                if (managerResponse instanceof ManagerError) {
                    this.events.setComplete(true);
                }
                if (this.events.isComplete()) {
                    this.events.notify();
                }
            }
        }
    }

    private class DefaultSendActionCallback
    implements SendActionCallback,
    Serializable {
        private static final long serialVersionUID = 2926598671855316803L;
        private final ResponseHandlerResult result;

        public DefaultSendActionCallback(ResponseHandlerResult responseHandlerResult) {
            this.result = responseHandlerResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onResponse(ManagerResponse managerResponse) {
            ResponseHandlerResult responseHandlerResult = this.result;
            synchronized (responseHandlerResult) {
                this.result.setResponse(managerResponse);
                this.result.notify();
            }
        }
    }

    private class ResponseHandlerResult
    implements Serializable {
        private static final long serialVersionUID = 7831097958568769220L;
        private ManagerResponse response;

        public ManagerResponse getResponse() {
            return this.response;
        }

        public void setResponse(ManagerResponse managerResponse) {
            this.response = managerResponse;
        }
    }
}

