/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.event;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asteriskjava.manager.event.ManagerEvent;

public class ChannelReloadEvent
extends ManagerEvent {
    private static final long serialVersionUID = 548974088194720544L;
    public static final String REASON_LOAD = "LOAD";
    public static final String REASON_RELOAD = "RELOAD";
    public static final String REASON_CLI_RELOAD = "CLIRELOAD";
    public static final String REASON_MANAGER_RELOAD = "MANAGERRELOAD";
    private static final Pattern REASON_PATTERN = Pattern.compile("^([A-Z]+) \\((.*)\\)$");
    private String channel;
    private String reloadReason;
    private String reloadReasonCode;
    private String reloadReasonDescription;
    private Integer registryCount;
    private Integer peerCount;
    private Integer userCount;

    public ChannelReloadEvent(Object object) {
        super(object);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String string) {
        this.channel = string;
    }

    public Integer getPeerCount() {
        return this.peerCount;
    }

    public void setPeerCount(Integer n) {
        this.peerCount = n;
    }

    public Integer getRegistryCount() {
        return this.registryCount;
    }

    public void setRegistryCount(Integer n) {
        this.registryCount = n;
    }

    public String getReloadReason() {
        return this.reloadReason;
    }

    public void setReloadReason(String string) {
        this.reloadReason = string;
        if (string == null) {
            return;
        }
        Matcher matcher = REASON_PATTERN.matcher(string);
        if (matcher.matches()) {
            this.reloadReasonCode = matcher.group(1);
            this.reloadReasonDescription = matcher.group(2);
        }
    }

    public String getReloadReasonCode() {
        return this.reloadReasonCode;
    }

    public String getReloadReasonDescription() {
        return this.reloadReasonDescription;
    }

    public Integer getUserCount() {
        return this.userCount;
    }

    public void setUserCount(Integer n) {
        this.userCount = n;
    }
}

