/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.AsteriskVersion;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.UserEventAction;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.internal.ActionBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActionBuilderImpl
implements ActionBuilder {
    private static final String LINE_SEPARATOR = "\r\n";
    private final Log logger = LogFactory.getLog(this.getClass());
    private AsteriskVersion targetVersion = AsteriskVersion.ASTERISK_1_0;

    ActionBuilderImpl() {
    }

    @Override
    public void setTargetVersion(AsteriskVersion asteriskVersion) {
        this.targetVersion = asteriskVersion;
    }

    @Override
    public String buildAction(ManagerAction managerAction) {
        return this.buildAction(managerAction, null);
    }

    @Override
    public String buildAction(ManagerAction managerAction, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("action: ");
        stringBuffer.append(managerAction.getAction());
        stringBuffer.append(LINE_SEPARATOR);
        if (string != null) {
            stringBuffer.append("actionid: ");
            stringBuffer.append(ManagerUtil.addInternalActionId(managerAction.getActionId(), string));
            stringBuffer.append(LINE_SEPARATOR);
        } else if (managerAction.getActionId() != null) {
            stringBuffer.append("actionid: ");
            stringBuffer.append(managerAction.getActionId());
            stringBuffer.append(LINE_SEPARATOR);
        }
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("class");
        hashSet.add("action");
        hashSet.add("actionid");
        if (managerAction instanceof UserEventAction) {
            UserEvent userEvent = ((UserEventAction)managerAction).getUserEvent();
            this.appendUserEvent(stringBuffer, userEvent);
            this.appendGetters(stringBuffer, userEvent, hashSet);
        } else {
            this.appendGetters(stringBuffer, managerAction, hashSet);
        }
        stringBuffer.append(LINE_SEPARATOR);
        return stringBuffer.toString();
    }

    private void appendMap(StringBuffer stringBuffer, String string, Map<String, String> map) {
        String string2 = string.endsWith("s") ? string.substring(0, string.length() - 1) : string;
        if (this.targetVersion.isAtLeast(AsteriskVersion.ASTERISK_1_2)) {
            this.appendMap12(stringBuffer, string2, map);
        } else {
            this.appendMap10(stringBuffer, string2, map);
        }
    }

    private void appendMap10(StringBuffer stringBuffer, String string, Map<String, String> map) {
        stringBuffer.append(string);
        stringBuffer.append(": ");
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            stringBuffer.append((Object)entry.getKey());
            stringBuffer.append("=");
            if (entry.getValue() != null) {
                stringBuffer.append((Object)entry.getValue());
            }
            if (!iterator.hasNext()) continue;
            stringBuffer.append("|");
        }
        stringBuffer.append(LINE_SEPARATOR);
    }

    private void appendMap12(StringBuffer stringBuffer, String string, Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            stringBuffer.append(string);
            stringBuffer.append(": ");
            stringBuffer.append((Object)entry.getKey());
            stringBuffer.append("=");
            if (entry.getValue() != null) {
                stringBuffer.append((Object)entry.getValue());
            }
            stringBuffer.append(LINE_SEPARATOR);
        }
    }

    private void appendString(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append(string);
        stringBuffer.append(": ");
        stringBuffer.append(string2);
        stringBuffer.append(LINE_SEPARATOR);
    }

    private void appendUserEvent(StringBuffer stringBuffer, UserEvent userEvent) {
        Class<?> clazz = userEvent.getClass();
        String string = clazz.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (string2.endsWith("event")) {
            string2 = string2.substring(0, string2.length() - "event".length());
        }
        this.appendString(stringBuffer, "UserEvent", string2);
    }

    private void appendGetters(StringBuffer stringBuffer, Object object, Set<String> set) {
        Map<String, Method> map = ReflectionUtil.getGetters(object.getClass());
        for (String string : map.keySet()) {
            Object object2;
            if (set.contains(string)) continue;
            Method method = map.get(string);
            try {
                object2 = method.invoke(object, new Object[0]);
            }
            catch (Exception exception) {
                this.logger.error("Unable to retrieve property '" + string + "' of " + object.getClass(), exception);
                continue;
            }
            if (object2 == null || object2 instanceof Class) continue;
            if (object2 instanceof Map) {
                this.appendMap(stringBuffer, string, (Map)object2);
                continue;
            }
            if (object2 instanceof String) {
                this.appendString(stringBuffer, string, (String)object2);
                continue;
            }
            this.appendString(stringBuffer, string, object2.toString());
        }
    }
}

