/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.asteriskjava.manager.event.DisconnectEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.ProtocolIdentifierReceivedEvent;
import org.asteriskjava.manager.internal.Dispatcher;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.EventBuilderImpl;
import org.asteriskjava.manager.internal.ManagerReader;
import org.asteriskjava.manager.internal.ResponseBuilder;
import org.asteriskjava.manager.internal.ResponseBuilderImpl;
import org.asteriskjava.manager.response.CommandResponse;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.DateUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.SocketConnectionFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerReaderImpl
implements ManagerReader {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final EventBuilder eventBuilder;
    private final ResponseBuilder responseBuilder;
    private final Dispatcher dispatcher;
    private final Object source;
    private SocketConnectionFacade socket;
    private boolean die = false;
    private boolean dead = false;
    private IOException terminationException;

    public ManagerReaderImpl(Dispatcher dispatcher, Object object) {
        this.dispatcher = dispatcher;
        this.source = object;
        this.eventBuilder = new EventBuilderImpl();
        this.responseBuilder = new ResponseBuilderImpl();
    }

    @Override
    public void setSocket(SocketConnectionFacade socketConnectionFacade) {
        this.socket = socketConnectionFacade;
    }

    @Override
    public void registerEventClass(Class clazz) {
        this.eventBuilder.registerEventClass(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        if (this.socket == null) {
            throw new IllegalStateException("Unable to run: socket is null.");
        }
        this.die = false;
        this.dead = false;
        try {
            String string;
            while ((string = this.socket.readLine()) != null && !this.die) {
                Object object;
                Object object2;
                if (bl) {
                    if ("--END COMMAND--".equals(string) || " --END COMMAND--".equals(string)) {
                        CommandResponse commandResponse = new CommandResponse();
                        for (int i = 0; i < arrayList.size(); ++i) {
                            object2 = ((String)arrayList.get(i)).split(" *: *", 2);
                            if (object2[0].equalsIgnoreCase("ActionID")) {
                                arrayList.remove(i--);
                                commandResponse.setActionId(object2[1]);
                                continue;
                            }
                            if (!object2[0].equalsIgnoreCase("Privilege")) break;
                            arrayList.remove(i--);
                        }
                        commandResponse.setResponse("Follows");
                        commandResponse.setDateReceived(DateUtil.getDate());
                        commandResponse.setResult(new ArrayList<String>(arrayList));
                        object = new HashMap<String, String>();
                        object.put("actionid", commandResponse.getActionId());
                        object.put("response", commandResponse.getResponse());
                        commandResponse.setAttributes((Map<String, String>)object);
                        this.dispatcher.dispatchResponse(commandResponse);
                        bl = false;
                        continue;
                    }
                    arrayList.add(string);
                    continue;
                }
                if ("Response: Follows".equalsIgnoreCase(string)) {
                    bl = true;
                    arrayList.clear();
                    continue;
                }
                if (string.startsWith("Asterisk Call Manager/") || string.startsWith("Asterisk Call Manager Proxy/") || string.startsWith("OpenPBX Call Manager/") || string.startsWith("CallWeaver Call Manager/")) {
                    ProtocolIdentifierReceivedEvent protocolIdentifierReceivedEvent = new ProtocolIdentifierReceivedEvent(this.source);
                    protocolIdentifierReceivedEvent.setProtocolIdentifier(string);
                    protocolIdentifierReceivedEvent.setDateReceived(DateUtil.getDate());
                    this.dispatcher.dispatchEvent(protocolIdentifierReceivedEvent);
                    continue;
                }
                if (string.length() == 0) {
                    if (hashMap.containsKey("event")) {
                        ManagerEvent managerEvent = this.buildEvent(this.source, hashMap);
                        if (managerEvent != null) {
                            this.dispatcher.dispatchEvent(managerEvent);
                        } else {
                            this.logger.debug("buildEvent returned null");
                        }
                    } else if (hashMap.containsKey("response")) {
                        ManagerResponse managerResponse = this.buildResponse(hashMap);
                        if (managerResponse != null) {
                            this.dispatcher.dispatchResponse(managerResponse);
                        }
                    } else if (hashMap.size() > 0) {
                        this.logger.debug("buffer contains neither response nor event");
                    }
                    hashMap.clear();
                    continue;
                }
                int n = string.indexOf(":");
                if (n <= 0 || string.length() <= n + 2) continue;
                object = string.substring(0, n).toLowerCase(Locale.ENGLISH);
                object2 = string.substring(n + 2);
                hashMap.put((String)object, (String)object2);
            }
            this.dead = true;
            this.logger.debug("Reached end of stream, terminating reader.");
        }
        catch (IOException iOException) {
            this.terminationException = iOException;
            this.dead = true;
            this.logger.info("Terminating reader thread: " + iOException.getMessage());
        }
        finally {
            this.dead = true;
            DisconnectEvent disconnectEvent = new DisconnectEvent(this.source);
            disconnectEvent.setDateReceived(DateUtil.getDate());
            this.dispatcher.dispatchEvent(disconnectEvent);
        }
    }

    @Override
    public void die() {
        this.die = true;
    }

    @Override
    public boolean isDead() {
        return this.dead;
    }

    @Override
    public IOException getTerminationException() {
        return this.terminationException;
    }

    private ManagerResponse buildResponse(Map<String, String> map) {
        ManagerResponse managerResponse = this.responseBuilder.buildResponse(map);
        if (managerResponse != null) {
            managerResponse.setDateReceived(DateUtil.getDate());
        }
        return managerResponse;
    }

    private ManagerEvent buildEvent(Object object, Map<String, String> map) {
        ManagerEvent managerEvent = this.eventBuilder.buildEvent(object, map);
        if (managerEvent != null) {
            managerEvent.setDateReceived(DateUtil.getDate());
        }
        return managerEvent;
    }
}

