#!/bin/bash

DEBUG=0
FORMAT=letter

if [ "$DEBUG" = "1" ]; then
echo FAXFILE=$FAXFILE
echo FAXPATH=$FAXPATH
echo REMOTESTATIONID=$REMOTESTATIONID
echo FAXPAGES=$FAXPAGES
echo FAXBITRATE=$FAXBITRATE
echo FAXRESOLUTION=$FAXRESOLUTION
echo FAXSENDER=$FAXSENDER
echo EMAILADDR=$EMAILADDR
fi

if [ "$FAXFILE" = "" ]; then
  echo "Error: A file is required"
  exit 1;
fi

if [ "$EMAILADDR" = "" ]; then
  echo "Error: A destantion email is required"
  exit 1;
fi

if [ ! -d "$FAXPATH" ]; then
  echo "Error: Directory $FAXPATH not found"
  exit 1;
fi
if [ ! -e "$FAXPATH/$FAXFILE.tif" ]; then
  echo "Error: File $FAXPATH/$FAXFILE.tif not found"
  exit 1;
fi

EMAILFROM=`echo $EMAILADDR |  cut -d " " -f 1`

cd $FAXPATH
FAXDT=$(tiffinfo ${FAXFILE}.tif | grep "Date" -m 1) 
DT=${FAXDT#*: }
if [ -z "$DT" ]
then
    DT=`date +"%F %T"`
fi 

DURS=$(tiffinfo ${FAXFILE}.tif | grep "Fax Receive Time" | cut -d " " -f 6)
DUR=0
for DP in $DURS
do
    (( DUR += $DP ))
done

BODY="Fax  Message

You have received $FAXPAGES page(s) fax from $FAXSENDER at $DT

Fax sessions parameters:
  RemoteID     $REMOTESTATIONID
  Bitrate      $FAXBITRATE
  Resolution   $FAXRESOLUTION
  Duration     $DUR secs  

Fax image can be viewed by Adobe Reader - you can get it at
  http://www.adobe.com/products/acrobat/readstep2.html

Sincerely yours,
THIRDLANE
"

tiff2pdf -f -p ${FORMAT} ${FAXFILE}.tif > ${FAXFILE}.pdf
/usr/local/sbin/sendEmail -f "$EMAILFROM" -t "$EMAILADDR" -u "fax from $FAXSENDER" -m "$BODY" -a ${FAXFILE}.pdf -o message-charset=UTF-8 -q  

rm ${FAXFILE}.pdf
