/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.asteriskjava.manager.event.AgentCallbackLoginEvent;
import org.asteriskjava.manager.event.AgentCallbackLogoffEvent;
import org.asteriskjava.manager.event.AgentCalledEvent;
import org.asteriskjava.manager.event.AgentCompleteEvent;
import org.asteriskjava.manager.event.AgentConnectEvent;
import org.asteriskjava.manager.event.AgentDumpEvent;
import org.asteriskjava.manager.event.AgentLoginEvent;
import org.asteriskjava.manager.event.AgentLogoffEvent;
import org.asteriskjava.manager.event.AgentsCompleteEvent;
import org.asteriskjava.manager.event.AgentsEvent;
import org.asteriskjava.manager.event.AlarmClearEvent;
import org.asteriskjava.manager.event.AlarmEvent;
import org.asteriskjava.manager.event.CdrEvent;
import org.asteriskjava.manager.event.ChannelReloadEvent;
import org.asteriskjava.manager.event.DbGetResponseEvent;
import org.asteriskjava.manager.event.DialEvent;
import org.asteriskjava.manager.event.DndStateEvent;
import org.asteriskjava.manager.event.ExtensionStatusEvent;
import org.asteriskjava.manager.event.FaxReceivedEvent;
import org.asteriskjava.manager.event.HangupEvent;
import org.asteriskjava.manager.event.HoldEvent;
import org.asteriskjava.manager.event.HoldedCallEvent;
import org.asteriskjava.manager.event.JoinEvent;
import org.asteriskjava.manager.event.LeaveEvent;
import org.asteriskjava.manager.event.LinkEvent;
import org.asteriskjava.manager.event.LogChannelEvent;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.MeetMeJoinEvent;
import org.asteriskjava.manager.event.MeetMeLeaveEvent;
import org.asteriskjava.manager.event.MeetMeMuteEvent;
import org.asteriskjava.manager.event.MeetMeStopTalkingEvent;
import org.asteriskjava.manager.event.MeetMeTalkingEvent;
import org.asteriskjava.manager.event.MessageWaitingEvent;
import org.asteriskjava.manager.event.NewCallerIdEvent;
import org.asteriskjava.manager.event.NewChannelEvent;
import org.asteriskjava.manager.event.NewExtenEvent;
import org.asteriskjava.manager.event.NewStateEvent;
import org.asteriskjava.manager.event.OriginateFailureEvent;
import org.asteriskjava.manager.event.OriginateResponseEvent;
import org.asteriskjava.manager.event.OriginateSuccessEvent;
import org.asteriskjava.manager.event.ParkedCallEvent;
import org.asteriskjava.manager.event.ParkedCallGiveUpEvent;
import org.asteriskjava.manager.event.ParkedCallTimeOutEvent;
import org.asteriskjava.manager.event.ParkedCallsCompleteEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.PeerStatusEvent;
import org.asteriskjava.manager.event.PeerlistCompleteEvent;
import org.asteriskjava.manager.event.QueueCallerAbandonEvent;
import org.asteriskjava.manager.event.QueueEntryEvent;
import org.asteriskjava.manager.event.QueueMemberAddedEvent;
import org.asteriskjava.manager.event.QueueMemberEvent;
import org.asteriskjava.manager.event.QueueMemberPausedEvent;
import org.asteriskjava.manager.event.QueueMemberRemovedEvent;
import org.asteriskjava.manager.event.QueueMemberStatusEvent;
import org.asteriskjava.manager.event.QueueParamsEvent;
import org.asteriskjava.manager.event.QueueStatusCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryCompleteEvent;
import org.asteriskjava.manager.event.QueueSummaryEvent;
import org.asteriskjava.manager.event.RegistryEvent;
import org.asteriskjava.manager.event.ReloadEvent;
import org.asteriskjava.manager.event.RenameEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.event.ShutdownEvent;
import org.asteriskjava.manager.event.StatusCompleteEvent;
import org.asteriskjava.manager.event.StatusEvent;
import org.asteriskjava.manager.event.UnholdEvent;
import org.asteriskjava.manager.event.UnlinkEvent;
import org.asteriskjava.manager.event.UnparkedCallEvent;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.event.ZapShowChannelsCompleteEvent;
import org.asteriskjava.manager.event.ZapShowChannelsEvent;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.asteriskjava.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventBuilderImpl
implements EventBuilder {
    private final Log logger = LogFactory.getLog(this.getClass());
    private Map<String, Class> registeredEventClasses = new HashMap<String, Class>();

    EventBuilderImpl() {
        this.registerBuiltinEventClasses();
    }

    private void registerBuiltinEventClasses() {
        this.registerEventClass(AgentCallbackLoginEvent.class);
        this.registerEventClass(AgentCallbackLogoffEvent.class);
        this.registerEventClass(AgentCalledEvent.class);
        this.registerEventClass(AgentConnectEvent.class);
        this.registerEventClass(AgentCompleteEvent.class);
        this.registerEventClass(AgentDumpEvent.class);
        this.registerEventClass(AgentLoginEvent.class);
        this.registerEventClass(AgentLogoffEvent.class);
        this.registerEventClass(AgentsEvent.class);
        this.registerEventClass(AgentsCompleteEvent.class);
        this.registerEventClass(AlarmEvent.class);
        this.registerEventClass(AlarmClearEvent.class);
        this.registerEventClass(CdrEvent.class);
        this.registerEventClass(ChannelReloadEvent.class);
        this.registerEventClass(DbGetResponseEvent.class);
        this.registerEventClass(DialEvent.class);
        this.registerEventClass(DndStateEvent.class);
        this.registerEventClass(ExtensionStatusEvent.class);
        this.registerEventClass(FaxReceivedEvent.class);
        this.registerEventClass(HangupEvent.class);
        this.registerEventClass(HoldedCallEvent.class);
        this.registerEventClass(HoldEvent.class);
        this.registerEventClass(JoinEvent.class);
        this.registerEventClass(LeaveEvent.class);
        this.registerEventClass(LinkEvent.class);
        this.registerEventClass(LogChannelEvent.class);
        this.registerEventClass(MeetMeJoinEvent.class);
        this.registerEventClass(MeetMeLeaveEvent.class);
        this.registerEventClass(MeetMeMuteEvent.class);
        this.registerEventClass(MeetMeTalkingEvent.class);
        this.registerEventClass(MeetMeStopTalkingEvent.class);
        this.registerEventClass(MessageWaitingEvent.class);
        this.registerEventClass(NewCallerIdEvent.class);
        this.registerEventClass(NewChannelEvent.class);
        this.registerEventClass(NewExtenEvent.class);
        this.registerEventClass(NewStateEvent.class);
        this.registerEventClass(OriginateFailureEvent.class);
        this.registerEventClass(OriginateSuccessEvent.class);
        this.registerEventClass(OriginateResponseEvent.class);
        this.registerEventClass(ParkedCallGiveUpEvent.class);
        this.registerEventClass(ParkedCallEvent.class);
        this.registerEventClass(ParkedCallTimeOutEvent.class);
        this.registerEventClass(ParkedCallsCompleteEvent.class);
        this.registerEventClass(PeerEntryEvent.class);
        this.registerEventClass(PeerlistCompleteEvent.class);
        this.registerEventClass(PeerStatusEvent.class);
        this.registerEventClass(QueueCallerAbandonEvent.class);
        this.registerEventClass(QueueEntryEvent.class);
        this.registerEventClass(QueueMemberAddedEvent.class);
        this.registerEventClass(QueueMemberEvent.class);
        this.registerEventClass(QueueMemberPausedEvent.class);
        this.registerEventClass(QueueMemberRemovedEvent.class);
        this.registerEventClass(QueueMemberStatusEvent.class);
        this.registerEventClass(QueueParamsEvent.class);
        this.registerEventClass(QueueStatusCompleteEvent.class);
        this.registerEventClass(QueueSummaryCompleteEvent.class);
        this.registerEventClass(QueueSummaryEvent.class);
        this.registerEventClass(RegistryEvent.class);
        this.registerEventClass(ReloadEvent.class);
        this.registerEventClass(RenameEvent.class);
        this.registerEventClass(ShutdownEvent.class);
        this.registerEventClass(StatusEvent.class);
        this.registerEventClass(StatusCompleteEvent.class);
        this.registerEventClass(UnholdEvent.class);
        this.registerEventClass(UnlinkEvent.class);
        this.registerEventClass(UnparkedCallEvent.class);
        this.registerEventClass(ZapShowChannelsEvent.class);
        this.registerEventClass(ZapShowChannelsCompleteEvent.class);
    }

    @Override
    public final void registerEventClass(Class clazz) throws IllegalArgumentException {
        String string = clazz.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (string2.endsWith("event")) {
            string2 = string2.substring(0, string2.length() - "event".length());
        }
        if (UserEvent.class.isAssignableFrom(clazz) && !string2.startsWith("userevent")) {
            string2 = "userevent" + string2;
        }
        this.registerEventClass(string2, clazz);
    }

    public final void registerEventClass(String string, Class clazz) throws IllegalArgumentException {
        Constructor constructor;
        if (!ManagerEvent.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(clazz + " is not a ManagerEvent");
        }
        if ((clazz.getModifiers() & 0x400) != 0) {
            throw new IllegalArgumentException(clazz + " is abstract");
        }
        try {
            constructor = clazz.getConstructor(Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException(clazz + " has no usable constructor");
        }
        if ((constructor.getModifiers() & 1) == 0) {
            throw new IllegalArgumentException(clazz + " has no public default constructor");
        }
        this.registeredEventClasses.put(string.toLowerCase(), clazz);
        this.logger.debug("Registered event type '" + string + "' (" + clazz + ")");
    }

    @Override
    public ManagerEvent buildEvent(Object object, Map<String, String> map) {
        String string;
        ManagerEvent managerEvent;
        Constructor constructor;
        Class clazz;
        Object object2;
        if (map.get("event") == null) {
            this.logger.error("No event event type in properties");
            return null;
        }
        String string2 = map.get("event").toLowerCase();
        if ("userevent".equals(string2)) {
            if (map.get("userevent") == null) {
                this.logger.error("No user event type in properties");
                return null;
            }
            object2 = map.get("userevent").toLowerCase();
            string2 = string2 + (String)object2;
        }
        if ((clazz = this.registeredEventClasses.get(string2)) == null) {
            this.logger.info("No event class registered for event type '" + string2 + "', attributes: " + map);
            return null;
        }
        try {
            constructor = clazz.getConstructor(Object.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.logger.error("Unable to get constructor of " + clazz.getName(), noSuchMethodException);
            return null;
        }
        try {
            managerEvent = (ManagerEvent)constructor.newInstance(object);
        }
        catch (Exception exception) {
            this.logger.error("Unable to create new instance of " + clazz.getName(), exception);
            return null;
        }
        this.setAttributes(managerEvent, map);
        if (managerEvent instanceof ResponseEvent && (string = ((ResponseEvent)(object2 = (ResponseEvent)managerEvent)).getActionId()) != null) {
            ((ResponseEvent)object2).setActionId(ManagerUtil.stripInternalActionId(string));
            ((ResponseEvent)object2).setInternalActionId(ManagerUtil.getInternalActionId(string));
        }
        return managerEvent;
    }

    private void setAttributes(ManagerEvent managerEvent, Map<String, String> map) {
        Map<String, Method> map2 = ReflectionUtil.getSetters(managerEvent.getClass());
        for (String string : map.keySet()) {
            Object object;
            if ("event".equals(string)) continue;
            Method method = "source".equals(string) ? map2.get("src") : map2.get(this.stripIllegalCharacters(string));
            if (method == null && !(managerEvent instanceof UserEvent)) {
                this.logger.error("Unable to set property '" + string + "' to '" + map.get(string) + "' on " + managerEvent.getClass().getName() + ": no setter");
            }
            if (method == null) continue;
            Class<String> clazz = method.getParameterTypes()[0];
            if (clazz == Boolean.class) {
                object = AstUtil.isTrue(map.get(string));
            } else if (clazz.isAssignableFrom(String.class)) {
                object = map.get(string);
            } else {
                try {
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    object = constructor.newInstance(map.get(string));
                }
                catch (Exception exception) {
                    this.logger.error("Unable to convert value '" + map.get(string) + "' of property '" + string + "' on " + managerEvent.getClass().getName() + " to required type " + clazz, exception);
                    continue;
                }
            }
            try {
                method.invoke((Object)managerEvent, object);
            }
            catch (Exception exception) {
                this.logger.error("Unable to set property '" + string + "' to '" + map.get(string) + "' on " + managerEvent.getClass().getName(), exception);
            }
        }
    }

    private String stripIllegalCharacters(String string) {
        char c;
        int n;
        boolean bl = false;
        if (string == null) {
            return null;
        }
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'z') continue;
            bl = true;
            break;
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
                continue;
            }
            if (c < 'a' || c > 'z') continue;
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

