#!/bin/bash

DEBUG=0

if [ "$DEBUG" = "1" ]; then
echo FAXFILE=$FAXFILE
echo FAXPATH=$FAXPATH
echo REMOTESTATIONID=$REMOTESTATIONID
echo FAXPAGES=$FAXPAGES
echo FAXBITRATE=$FAXBITRATE
echo FAXRESOLUTION=$FAXRESOLUTION
echo FAXSENDER=$FAXSENDER
echo EMAILADDR=$EMAILADDR
fi

if [ "$EMAILADDR" = "" ]; then
  echo "Error: A destantion email is required"
  exit 1;
fi

if [ "$FAXFILE" = "" ]; then
  echo "Error: A file is required"
  exit 1;
fi

if [ ! -e "$FAXFILE" ]; then
  echo "Error: File $FAXFILE not found"
  exit 1;
fi
DATE=`date`
EMAILFROM="Thirdlane PBX<thirdlane@`hostname`>"

function confirm() {
	BODY="Fax Success

Fax message to $REMOTENUMBER completed successfully on $DATE .

Details:
  RemoteID	$REMOTESTATIONID
  Bitrate	$FAXBITRATE
  Pages		$FAXPAGES

Sincerely yours,
   Thirdlane.
"
	/usr/local/sbin/sendEmail -f "$EMAILFROM" -t $EMAILADDR -u "Successful Fax Transmission" -m "$BODY" -o message-charset=UTF-8 -q  
}
function error_report() {
	BODY="Fax Error

There was a error during transmission of the fax to $REMOTENUMBER. 

Detials:
  Status	$STATUS
  Error		$FAXERROR
  Pages Sent	$FAXPAGES
  Bitrate	$FAXBITRATE

Sincerely yours,
   Thirdlane.
"
	/usr/local/sbin/sendEmail -f "$EMAILFROM" -t $EMAILADDR -u "Failure sending fax" -m "$BODY" -o message-charset=UTF-8 -q  
}

function failure_trying() {
   case "$REASON" in
	0)
	   REASONING="General error calling number; not otherwise specified.";
	   ;;
	1)
	   REASONING="The remote party disconnects before faxing begins.";
	   ;;
	3)
	   REASONING="No answer from remote party.";
	   ;;
	5)
	   REASONING="Remote number returns BUSY.";
	   ;;
	8)
	   REASONING="All circuits are busy at this time.";
	   ;;	
   esac
   BODY="Fax failure

There was a failure sending your fax $REMOTENUMBER.

Reason for failure:
$REASONING

All retry attempts have been exhausted.

Sincerely yours,
   Thirdlane.
"
	/usr/local/sbin/sendEmail -f "$EMAILFROM" -t $EMAILADDR -u "Failure sending fax" -m "$BODY" -o message-charset=UTF-8 -q  
}
case "$STATUS" in
   SUCCESS)
	if [ "$CONFSUCCESS" = "1" ];
	then
	   confirm;
	fi
	;;
   FAILED)
	error_report;
	;;
   *)
	if [ "$FAILED" = "2" ];
	then
	   failure_trying;
	fi
	;;
esac

rm ${FAXFILE}
