# to force creation of a systemd service unit run rpmbuild --define 'systemd 1'
# to force creation of a System V init script run rpmbuild --define 'systemd 0'
# to add a distro release tag run rpmbuild --define 'dist value'
# to add a revision tag run rpmbuild --define 'revision value'
# to create a debug info package run rpmbuild --define 'debuginfo 1'
# to suppress auto dependencies run rpmbuild --define 'nodeps 1'
# to disable all PSTN card drivers run rpmbuild --define 'nopstn 1'
# to disable USB support run rpmbuild --define 'nousb 1'
# to disable SCTP support run rpmbuild --define 'nosctp 1'
# to disable H.323 support run rpmbuild --define 'noh323 1'
# to disable AMR codecs run rpmbuild --define 'noamr 1'
# to disable the GUI clients run rpmbuild --define 'nogui 1'
# to disable only Zaptel support run rpmbuild --define 'nozap 1'
# to disable only TDMV support run rpmbuild --define 'notdm 1'

%{!?systemd:%define systemd %(test -x /usr/bin/systemd && echo 1 || echo 0)}
%{!?_unitdir:%define _unitdir /usr/lib/systemd/system}
%{!?dist:%define dist %{nil}}
%if "" == ""
%{!?status:%define status %{nil}}
%else
%{!?status:%define status }
%endif
%{!?revision:%define revision %{nil}}
%{?nodeps:%define no_auto_deps 1}
%{?nopstn:%define no_pstn 1}
%{?nousb:%define no_usb 1}
%{?nosctp:%define no_sctp 1}
%{?noh323:%define no_h323 1}
%{?noamr:%define no_amr 1}
%{?nogui:%define no_gui 1}
%{?nozap:%define no_zaptel 1}
%{?notdm:%define no_tdmapi 1}

%{!?debuginfo:%define debuginfo %{nil}}
%if "%{debuginfo}"
%define stripped debug
%else
%define stripped strip
%define debug_package ${nil}
%endif

%if "%{revision}" == "svn"
%define revision 6319svn
%endif

%if "%{dist}" == ""
%define dist %{?distsuffix:%distsuffix}%{?product_version:%product_version}
%endif
%if "%{dist}" == ""
%define dist %(test -f /etc/mandriva-release && echo mdv)
%endif
%if "%{dist}" == ""
%define dist %(test -f /etc/mandrake-release && echo mdk)
%endif
%if "%{dist}" == ""
%define dist %(test -f /etc/fedora-release && echo fc)
%endif
%if "%{dist}" == ""
%define dist %(grep -q ^CentOS /etc/issue && echo centos)
%endif
%if "%{dist}" == ""
%define dist %(test -f /etc/redhat-release && echo rh)
%endif
%if "%{dist}" == ""
%define dist %(test -f /etc/SuSE-release && echo suse)
%endif
%if "%{dist}" == "none"
%define dist %{nil}
%endif

Summary:	Yet Another Telephony Engine
Name:     	yate
Version: 	6.1.0
Release:	%{status}%{revision}1%{dist}
License:	GPL
Packager:	Paul Chitescu <paulc@voip.null.ro>
Source:		http://yate.null.ro/tarballs/yate6/yate-6.1.0-1.tar.gz
Group:		Applications/Communication
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root
URL:		http://yate.null.ro/
%{?extra_prov:Provides: %{?extra_prov}}
%{?extra_reqs:Requires: %{?extra_reqs}}
BuildRequires:	gcc-c++
# Distro maintainers please add other BuildRequires below this line

%define prefix  /usr


%description
Yate is a telephony engine designed to implement PBX and IVR solutions
for small to large scale projects.

%files
%defattr(-, root, root)
%dir %{_defaultdocdir}/yate-%{version}
%doc %{_defaultdocdir}/yate-%{version}/README
%doc %{_defaultdocdir}/yate-%{version}/COPYING
%doc %{_defaultdocdir}/yate-%{version}/ChangeLog
%doc %{_defaultdocdir}/yate-%{version}/iLBC-LICENSE.txt
%doc %{_defaultdocdir}/yate-%{version}/WebRTC-LICENSE
%doc %{_defaultdocdir}/yate-%{version}/WebRTC-LICENSE_THIRD_PARTY
%doc %{_defaultdocdir}/yate-%{version}/WebRTC-PATENTS
%{_libdir}/libyate.so.*
%{_libdir}/libyatescript.so.*
%{_libdir}/libyatejabber.so.*
%{_libdir}/libyatesig.so.*
%{_libdir}/libyateasn.so.*
%{_libdir}/libyateradio.so.*
%{_libdir}/libyatemgcp.so.*
%{_bindir}/yate
%{_mandir}/*/yate.*
%if "%{systemd}" != "0"
%{_unitdir}/yate.service
%else
%{_initrddir}/yate
%endif
%dir %{_datadir}/yate/data
%{_datadir}/yate/data/*MIB.txt
%{_datadir}/yate/data/snmp_mib.conf
%dir %{_libdir}/yate
%{_libdir}/yate/cdrbuild.yate
%{_libdir}/yate/cdrcombine.yate
%{_libdir}/yate/cdrfile.yate
%{_libdir}/yate/regexroute.yate
%{_libdir}/yate/javascript.yate
%{_libdir}/yate/server/regfile.yate
%{_libdir}/yate/server/accfile.yate
%{_libdir}/yate/server/register.yate
%{_libdir}/yate/tonegen.yate
%{_libdir}/yate/tonedetect.yate
%{_libdir}/yate/wavefile.yate
%{_libdir}/yate/conference.yate
%{_libdir}/yate/moh.yate
%{_libdir}/yate/callgen.yate
%{_libdir}/yate/analyzer.yate
%{_libdir}/yate/rmanager.yate
%{_libdir}/yate/msgsniff.yate
%{_libdir}/yate/mux.yate
%{_libdir}/yate/pbx.yate
%{_libdir}/yate/dumbchan.yate
%{_libdir}/yate/callfork.yate
%{_libdir}/yate/extmodule.yate
%{_libdir}/yate/fileinfo.yate
%{_libdir}/yate/filetransfer.yate
%{_libdir}/yate/ysipchan.yate
%{_libdir}/yate/yrtpchan.yate
%{_libdir}/yate/ystunchan.yate
%{_libdir}/yate/ysockschan.yate
%{_libdir}/yate/yiaxchan.yate
%{_libdir}/yate/yjinglechan.yate
%{_libdir}/yate/enumroute.yate
%{_libdir}/yate/ilbccodec.yate
%{_libdir}/yate/ilbcwebrtc.yate
%{_libdir}/yate/isaccodec.yate
%{_libdir}/yate/gvoice.yate
%{_libdir}/yate/server/dbwave.yate
%{_libdir}/yate/server/dbpbx.yate
%{_libdir}/yate/server/pbxassist.yate
%{_libdir}/yate/server/park.yate
%{_libdir}/yate/server/queues.yate
%{_libdir}/yate/server/lateroute.yate
%{_libdir}/yate/server/callcounters.yate
%{_libdir}/yate/server/yradius.yate
%{_libdir}/yate/server/sipfeatures.yate
%{_libdir}/yate/server/queuesnotify.yate
%{_libdir}/yate/server/heartbeat.yate
%{_libdir}/yate/server/clustering.yate
%{_libdir}/yate/server/mgcpca.yate
%{_libdir}/yate/server/mgcpgw.yate
%{_libdir}/yate/server/mrcpspeech.yate
%{_libdir}/yate/server/ysigchan.yate
%{_libdir}/yate/server/ciscosm.yate
%{_libdir}/yate/server/sigtransport.yate
%{_libdir}/yate/server/analog.yate
%{_libdir}/yate/server/analogdetect.yate
%{_libdir}/yate/server/users.yate
%{_libdir}/yate/server/presence.yate
%{_libdir}/yate/server/subscription.yate
%{_libdir}/yate/server/cpuload.yate
%{_libdir}/yate/server/ccongestion.yate
%{_libdir}/yate/server/monitoring.yate
%{_libdir}/yate/server/ysnmpagent.yate
%{_libdir}/yate/server/cache.yate
%{_libdir}/yate/server/eventlogs.yate
%{_libdir}/yate/client/osschan.yate
%{_libdir}/yate/client/jabberclient.yate
%{_libdir}/yate/jabber/jabberserver.yate
%{_libdir}/yate/jabber/jbfeatures.yate
%{_libdir}/yate/sig/isupmangler.yate
%{_libdir}/yate/sig/ss7_lnp_ansi.yate
%{_libdir}/yate/sig/camel_map.yate
%{_libdir}/yate/sip/sip_cnam_lnp.yate
%{_libdir}/yate/radio/dummyradio.yate
%{_libdir}/yate/radio/radiotest.yate
%dir %{_sysconfdir}/yate
%config(noreplace) %{_sysconfdir}/yate/accfile.conf
%config(noreplace) %{_sysconfdir}/yate/cdrbuild.conf
%config(noreplace) %{_sysconfdir}/yate/cdrfile.conf
%config(noreplace) %{_sysconfdir}/yate/callcounters.conf
%config(noreplace) %{_sysconfdir}/yate/dbpbx.conf
%config(noreplace) %{_sysconfdir}/yate/dsoundchan.conf
%config(noreplace) %{_sysconfdir}/yate/enumroute.conf
%config(noreplace) %{_sysconfdir}/yate/sipfeatures.conf
%config(noreplace) %{_sysconfdir}/yate/callfork.conf
%config(noreplace) %{_sysconfdir}/yate/extmodule.conf
%config(noreplace) %{_sysconfdir}/yate/fileinfo.conf
%config(noreplace) %{_sysconfdir}/yate/filetransfer.conf
%config(noreplace) %{_sysconfdir}/yate/moh.conf
%config(noreplace) %{_sysconfdir}/yate/mux.conf
%config(noreplace) %{_sysconfdir}/yate/pbxassist.conf
%config(noreplace) %{_sysconfdir}/yate/queues.conf
%config(noreplace) %{_sysconfdir}/yate/queuesnotify.conf
%config(noreplace) %{_sysconfdir}/yate/lateroute.conf
%config(noreplace) %{_sysconfdir}/yate/regexroute.conf
%config(noreplace) %{_sysconfdir}/yate/javascript.conf
%config(noreplace) %{_sysconfdir}/yate/regfile.conf
%config(noreplace) %{_sysconfdir}/yate/register.conf
%config(noreplace) %{_sysconfdir}/yate/tonegen.conf
%config(noreplace) %{_sysconfdir}/yate/rmanager.conf
%config(noreplace) %{_sysconfdir}/yate/yate.conf
%config(noreplace) %{_sysconfdir}/yate/yiaxchan.conf
%config(noreplace) %{_sysconfdir}/yate/yradius.conf
%config(noreplace) %{_sysconfdir}/yate/yrtpchan.conf
%config(noreplace) %{_sysconfdir}/yate/ysockschan.conf
%config(noreplace) %{_sysconfdir}/yate/ystunchan.conf
%config(noreplace) %{_sysconfdir}/yate/ysipchan.conf
%config(noreplace) %{_sysconfdir}/yate/yjinglechan.conf
%config(noreplace) %{_sysconfdir}/yate/gvoice.conf
%config(noreplace) %{_sysconfdir}/yate/heartbeat.conf
%config(noreplace) %{_sysconfdir}/yate/clustering.conf
%config(noreplace) %{_sysconfdir}/yate/mgcpca.conf
%config(noreplace) %{_sysconfdir}/yate/mgcpgw.conf
%config(noreplace) %{_sysconfdir}/yate/analog.conf
%config(noreplace) %{_sysconfdir}/yate/ysigchan.conf
%config(noreplace) %{_sysconfdir}/yate/ciscosm.conf
%config(noreplace) %{_sysconfdir}/yate/sigtransport.conf
%config(noreplace) %{_sysconfdir}/yate/cpuload.conf
%config(noreplace) %{_sysconfdir}/yate/ccongestion.conf
%config(noreplace) %{_sysconfdir}/yate/monitoring.conf
%config(noreplace) %{_sysconfdir}/yate/ysnmpagent.conf
%config(noreplace) %{_sysconfdir}/yate/cache.conf
%config(noreplace) %{_sysconfdir}/yate/eventlogs.conf
%config(noreplace) %{_sysconfdir}/yate/users.conf
%config(noreplace) %{_sysconfdir}/yate/presence.conf
%config(noreplace) %{_sysconfdir}/yate/subscription.conf
%config(noreplace) %{_sysconfdir}/yate/jabberclient.conf
%config(noreplace) %{_sysconfdir}/yate/jabberserver.conf
%config(noreplace) %{_sysconfdir}/yate/jbfeatures.conf
%config(noreplace) %{_sysconfdir}/yate/isupmangler.conf
%config(noreplace) %{_sysconfdir}/yate/ss7_lnp_ansi.conf
%config(noreplace) %{_sysconfdir}/yate/camel_map.conf
%config(noreplace) %{_sysconfdir}/yate/sip_cnam_lnp.conf
%config(noreplace) %{_sysconfdir}/yate/dummyradio.conf

%config %{_sysconfdir}/logrotate.d/yate

%post
ldconfig

%postun
ldconfig


%package alsa
Summary:	ALSA sound driver for Yate
Group:		Applications/Communication
ExclusiveOS:	linux
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-audiodevice

%description alsa
Advanced Linux Sound Architecture audio driver for Yate. This is the recommended
audio interface for using the client under Linux.

%files alsa
%{_libdir}/yate/client/alsachan.yate


%package gsm
Summary:	GSM audio codec for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}

%description gsm
European GSM 06.10 audio codec for Yate. This is a low CPU usage codec that
provides moderate compression and good voice quality.

%files gsm
%{_libdir}/yate/gsmcodec.yate


%if "%{no_amr}" != "1"

%package amr
Summary:	GSM-AMR and GSM-EFR audio codecs for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}

%description amr
GSM-AMR and GSM-EFR audio codecs for Yate. AMR is a multi-rate codec that provides moderate
to high compression rate and good voice quality. EFR is just a different payload stucture
for 12.2 kbit/s AMR-NB.

%files amr
%{_libdir}/yate/amrnbcodec.yate
%{_libdir}/yate/efrcodec.yate
%config(noreplace) %{_sysconfdir}/yate/amrnbcodec.conf

%define conf_amr %{nil}
%else
%define conf_amr --without-amrnb
%endif


%package speex
Summary:	Speex audio codec for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}

%description speex
Speex audio codec for Yate. Speex is based on CELP  and is designed to
compress voice at bitrates ranging from 2 to 44 kbps.

%files speex
%{_libdir}/yate/speexcodec.yate


%if "%{no_h323}" != "1"

%package h323
Summary:	H.323 protocol driver for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}

%description h323
Yate driver for the ITU-T H.323 VoIP protocol based on the OpenH323 library.

%files h323
%{_libdir}/yate/h323chan.yate
%config(noreplace) %{_sysconfdir}/yate/h323chan.conf

%define conf_h323 %{nil}
%else
%define conf_h323 --without-pwlib
%endif


%if "%{no_pstn}" != "1"

%define conf_pstn %{conf_zaptel} %{conf_tdmapi}

%package isdn
Summary:	ISDN PRI card and protocol drivers for Yate
Group:		Applications/Communication
ExclusiveOS:	linux
Requires:	%{name} = %{version}-%{release}

%description isdn
Yate drivers for ISDN PRI cards supported by the Zaptel or Wanpipe kernel
interfaces.

%files isdn
%{_libdir}/yate/server/wpcard.yate
%config(noreplace) %{_sysconfdir}/yate/wpcard.conf

%if "%{no_zaptel}" != "1"
%{_libdir}/yate/server/zapcard.yate
%config(noreplace) %{_sysconfdir}/yate/zapcard.conf
%define conf_zaptel --enable-zaptel
%else
%define conf_zaptel --disable-zaptel
%endif

%if "%{no_tdmapi}" != "1"
%{_libdir}/yate/server/tdmcard.yate
%config(noreplace) %{_sysconfdir}/yate/tdmcard.conf
%define conf_tdmapi --enable-tdmcard
%else
%define conf_tdmapi --disable-tdmcard
%endif

%else
%define conf_pstn --disable-wpcard --disable-zaptel --disable-tdmcard
%endif


%if "%{no_sctp}" != "1"

%package lksctp
Summary:	Linux Kernel based SCTP support for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-sctp

%description lksctp
This package provides SCTP sockets support for Yate based on the Linux Kernel
implementation. These are needed for standard SIGTRAN interfaces.

%files lksctp
%{_libdir}/yate/server/lksctp.yate
%config(noreplace) %{_sysconfdir}/yate/lksctp.conf

%define conf_sctp --enable-sctp
%else
%define conf_sctp --disable-sctp
%endif


%package openssl
Summary:	OpenSSL based encryption support for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-ssl
Provides:	%{name}-crypto

%description openssl
This package provides SSL/TLS encrypted communication support for Yate as
well as cryptographic routines used for other purposes.

%files openssl
%{_libdir}/yate/openssl.yate
%config(noreplace) %{_sysconfdir}/yate/openssl.conf


%package zlib
Summary:	Zlib compression support for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-compression

%description zlib
This package provides Zlib data compression for Yate.

%files zlib
%{_libdir}/yate/zlibcompress.yate
%config(noreplace) %{_sysconfdir}/yate/zlibcompress.conf


%package pgsql
Summary:	PostgreSQL database driver for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-database

%description pgsql
This package allows Yate to connect to a PostgreSQL database server. All
modules that support database access will be able to use PostgreSQL.

%files pgsql
%{_libdir}/yate/server/pgsqldb.yate
%config(noreplace) %{_sysconfdir}/yate/pgsqldb.conf


%package mysql
Summary:	MySQL database driver for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-database

%description mysql
This package allows Yate to connect to a MySQL database server. All modules
that support database access will be able to use MySQL.

%files mysql
%{_libdir}/yate/server/mysqldb.yate
%config(noreplace) %{_sysconfdir}/yate/mysqldb.conf


%package sqlite
Summary:	SQLite database driver for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-database

%description sqlite
This package allows Yate to use SQLite database files. All modules
that support database access will be able to use SQLite.

%files sqlite
%{_libdir}/yate/server/sqlitedb.yate
%config(noreplace) %{_sysconfdir}/yate/sqlitedb.conf


%if "%{no_gui}" != "1"

%package client-common
Summary:	Common files for all Yate clients
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}

%description client-common
This package includes the common files needed to use Yate as a VoIP client.

%files client-common
%defattr(-, root, root)
%{_datadir}/pixmaps/null_team-*.png
%dir %{_datadir}/yate/skins
%{_datadir}/yate/skins/*
%dir %{_datadir}/yate/sounds
%{_datadir}/yate/sounds/*
%dir %{_datadir}/yate/help
%{_datadir}/yate/help/*
%config(noreplace) %{_sysconfdir}/yate/providers.conf


%package qt4
Summary:	Qt-4 client package for Yate
Group:		Applications/Communication
Provides:	%{name}-client
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-client-common = %{version}-%{release}

%description qt4
The yate-qt4 package includes the files needed to use Yate as a VoIP client
with a Qt version 4 graphical interface.

%files qt4
%defattr(-, root, root)
%{_bindir}/yate-qt4
%{_libdir}/libyateqt4.so.*
%{_libdir}/yate/qt4/*.yate
%{_menudir}/yate-qt4.menu
%{_datadir}/applications/yate-qt4.desktop
%config(noreplace) %{_sysconfdir}/yate/yate-qt4.conf

%post qt4
test -x /usr/bin/update-menus && /usr/bin/update-menus || /bin/true

%postun qt4
test -x /usr/bin/update-menus && /usr/bin/update-menus || /bin/true

%define conf_gui %{nil}
%else
%define conf_gui --without-libqt4
%endif


%if "%{no_usb}" != "1"

%package bladerf
Summary:	Yate radio interface for the bladeRF board
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-radio

%description bladerf
This package provides support for bladeRF radio boards http://nuand.com/

%files bladerf
%{_libdir}/yate/radio/ybladerf.yate
%{_datadir}/yate/data/hosted*.rbf
%config(noreplace) %{_sysconfdir}/yate/ybladerf.conf

%define conf_usb %{nil}
%else
%define conf_usb --without-libusb
%endif


%package scripts
Summary:	External scripting package for Yate
Group:		Applications/Communication
Requires:	%{name}

%description scripts
The yate-scripts package includes libraries for using external scripts with Yate.

%files scripts
%dir %{_datadir}/yate/scripts
%{_datadir}/yate/scripts/*.*


%package devel
Summary:	Development package for Yate
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description devel
The yate-devel package includes the libraries and header files for Yate that
can be used to build and install new modules.

%files devel
%defattr(-, root, root)
%doc %{_datadir}/doc/yate-%{version}/*.html
%doc %{_datadir}/doc/yate-%{version}/api/*
/usr/include/*
%{_libdir}/lib*.so
%{_bindir}/yate-config
%{_mandir}/*/yate-config.*
%{_libdir}/pkgconfig/yate.pc


%package all
Summary:	Metapackage for Yate
Group:		Applications/Communication
Requires:	%{name} = %{version}-%{release}
%ifos Linux
Requires:	%{name}-alsa = %{version}-%{release}
%endif
Requires:	%{name}-gsm = %{version}-%{release}
Requires:	%{name}-speex = %{version}-%{release}
%if "%{no_h323}" != "1"
Requires:	%{name}-h323 = %{version}-%{release}
%endif
%if "%{no_pstn}" != "1"
Requires:	%{name}-isdn = %{version}-%{release}
%endif
%if "%{no_sctp}" != "1"
Requires:	%{name}-lksctp = %{version}-%{release}
%endif
Requires:	%{name}-openssl = %{version}-%{release}
Requires:	%{name}-zlib = %{version}-%{release}
Requires:	%{name}-mysql = %{version}-%{release}
Requires:	%{name}-pgsql = %{version}-%{release}
%if "%{no_gui}" != "1"
Requires:	%{name}-qt4 = %{version}-%{release}
%endif
Requires:	%{name}-scripts = %{version}-%{release}

%description all
Metapackage for Yate allowing to fetch and install all components at once.
It contains no files, just dependencies to all other packages.
The devel package must still be installed separately.

%files all
%defattr(-,root,root)


# disable unpackaged files check if we know we are going to skip some
%if "%{no_pstn}" == "1"
%define _unpackaged_files_terminate_build 0
%endif
%if "%{no_zaptel}" == "1"
%define _unpackaged_files_terminate_build 0
%endif
%if "%{no_tdmapi}" == "1"
%define _unpackaged_files_terminate_build 0
%endif
%if "%{no_h323}" == "1"
%define _unpackaged_files_terminate_build 0
%endif
%if "%{no_amr}" == "1"
%define _unpackaged_files_terminate_build 0
%endif
%if "%{no_gui}" == "1"
%define _unpackaged_files_terminate_build 0
%endif
%ifnos Linux
%define _unpackaged_files_terminate_build 0
%endif

%prep
%setup -q -n %{name}

# older rpmbuild uses these macro basic regexps
%define _provides_exceptions pear(libyate\\|devel(libyate
%define _requires_exceptions pear(libyate\\|devel(libyate\\|devel(libQt
# newer rpmbuild needs these global extended regexps
%global __provides_exclude pear\\(libyate|devel\\(libyate
%global __requires_exclude pear\\(libyate|devel\\(libyate|devel\\(libQt
#
%if "%{no_auto_deps}" == "1"
%define local_find_requires %{_builddir}/%{name}/local-find-requires
%define local_find_provides %{_builddir}/%{name}/local-find-provides
#
%{__cat} <<EOF >%{local_find_requires}
#! /bin/sh
grep -v '\.yate$' | %{__find_requires} | grep -v '^perl' | grep -v 'libyate\.php'
exit 0
EOF
#
%{__cat} <<EOF >%{local_find_provides}
#! /bin/sh
%{__find_provides} | grep -v '\.yate$'
exit 0
EOF
#
chmod +x %{local_find_requires} %{local_find_provides}
%define _use_internal_dependency_generator 0
%define __find_requires %{local_find_requires}
%define __find_provides %{local_find_provides}
%define __perl_requires /bin/true
%endif

%build
./configure --prefix=%{prefix} --sysconfdir=%{_sysconfdir} \
	--datadir=%{_datadir} --includedir=%{_includedir} \
	--libdir=%{_libdir} --mandir=%{_mandir} --with-archlib=%{_lib} \
	--without-spandsp --without-coredumper \
	%{conf_sctp} %{conf_h323} %{conf_amr} %{conf_pstn} %{conf_usb} %{conf_gui} \
	%{?extra_conf}
make %{stripped} %{?extra_make}
%{?extra_step}

%install
make install DESTDIR=%{buildroot} %{?extra_make}
rm %{buildroot}%{_sysconfdir}/yate/radiotest.conf
%if "%{systemd}" != "0"
mkdir -p %{buildroot}%{_unitdir}
cp -p %{_builddir}/%{name}/packing/rpm/yate.service %{buildroot}%{_unitdir}/yate.service
%else
mkdir -p %{buildroot}%{_initrddir}
cp -p %{_builddir}/%{name}/packing/rpm/yate.init %{buildroot}%{_initrddir}/yate
%endif
mkdir -p %{buildroot}%{_sysconfdir}/logrotate.d
cp -p %{_builddir}/%{name}/packing/yate.logrotate %{buildroot}%{_sysconfdir}/logrotate.d/yate
echo '<?php global $yate_version; $yate_version = "%{version}-%{release}"; ?>' > %{buildroot}%{_datadir}/yate/scripts/yateversn.php
%if "%{?extra_inst}"
export DESTDIR=%{buildroot}
%{?extra_inst}
%endif

%clean
# make clean
rm -rf %{buildroot}


%changelog
* Fri Nov 25 2016 Paul Chitescu <paulc@voip.null.ro>
- Added package for the AMR codec

* Thu Nov 26 2015 Paul Chitescu <paulc@voip.null.ro>
- More tweaking to suppress unwanted dependencies in newer RPM

* Tue Apr 07 2015 Marian Podgoreanu <marian@voip.null.ro>
- Renamed GSM Layer 3 radio library

* Wed Apr 01 2015 Paul Chitescu <paulc@voip.null.ro>
- Package the new dynamic libyateasn.so

* Tue Apr 29 2014 Paul Chitescu <paulc@voip.null.ro>
- Added SQLite module and subpackage

* Mon Apr 23 2012 Paul Chitescu <paulc@voip.null.ro>
- Added new support module gvoice

* Fri Feb 10 2012 Paul Chitescu <paulc@voip.null.ro>
- Added scripting library and javascript module
- Added cache and camel_map modules

* Thu Sep 15 2011 Paul Chitescu <paulc@voip.null.ro>
- Added new modules/sig directory for feature modules

* Fri Dec 10 2010 Paul Chitescu <paulc@voip.null.ro>
- Properly pack the new dynamic Qt client library and modules
- Added missing CPU load and congestion control modules

* Wed Nov 03 2010 Ioana Stanciu <oana@voip.null.ro>
- Added SNMP support

* Thu Sep 09 2010 Paul Chitescu <paulc@voip.null.ro>
- Added isupmangler to packaging

* Fri Jul 16 2010 Paul Chitescu <paulc@voip.null.ro>
- Added zlib subpackage

* Tue Feb 02 2010 Paul Chitescu <paulc@voip.null.ro>
- Moved some modules to new location in Yate 3
- Added new modules
- Support for SCTP can be disabled from build

* Mon Nov 02 2009 Paul Chitescu <paulc@voip.null.ro>
- Added new modules to main package and qt4client
- Fixed distro and revision variables

* Fri Jun 20 2008 Paul Chitescu <paulc@voip.null.ro>
- Option to remove H.323 subpackage
- Added missing openssl subpackage

* Fri May 30 2008 Paul Chitescu <paulc@voip.null.ro>
- Removed GTK client

* Thu May 15 2008 Paul Chitescu <paulc@voip.null.ro>
- Disabled the newly added AMR-NB from building

* Mon Jan 07 2008 Paul Chitescu <paulc@voip.null.ro>
- Added Qt client

* Fri Dec 14 2007 Paul Chitescu <paulc@voip.null.ro>
- Modified for Yate 2

* Sun Jul 22 2007 Paul Chitescu <paulc@voip.null.ro>
- Added new modules and config files

* Sat Apr 14 2007 Paul Chitescu <paulc@voip.null.ro>
- Version 1.2.0-1
- Disabled detection of speex, fax and coredumper

* Sun Feb 11 2007 Paul Chitescu <paulc@voip.null.ro>
- Properly create the logrotate directory

* Fri Jan 26 2007 Paul Chitescu <paulc@voip.null.ro>
- Added log rotator configuration

* Mon Sep 18 2006 Paul Chitescu <paulc@voip.null.ro>
- Version 1.1.0-1

* Mon Jul 10 2006 Paul Chitescu <paulc@voip.null.ro>
- Added metapackage yate-all

* Fri Jul 07 2006 Paul Chitescu <paulc@voip.null.ro>
- Built separate packages for modules with external dependencies
- By default packages have dependencies

* Tue Jul 04 2006 Paul Chitescu <paulc@voip.null.ro>
- Version 1.0.0-pre1
- Capability to add a distro release tag at rpmbuild time

* Fri Jun 16 2006 Paul Chitescu <paulc@voip.null.ro>
- Added .desktop and .menu files and update-menus scriptlets

* Mon Nov 07 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.9.0-pre4
- Separated modules and scripts directories

* Mon Oct 24 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.9.0-pre3
- Changed obsolete Copyright: tag to License: to keep newer RPMs happy

* Mon Oct 10 2005 Diana Cionoiu <diana@diana.null.ro>
- Version 0.9.0-pre2

* Tue Sep 06 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.9.0-pre1

* Tue Jan 18 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.7

* Mon Jan 10 2005 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.6
- Versioned the shared library and packaged manpage for yate-config

* Sun Jan 09 2005 Paul Chitescu <paulc-devel@null.ro>
- Cleaned up the build and packaging system

* Wed Dec 15 2004 Paul Chitescu <paulc-devel@null.ro>
- Added custom requires/provides filters to supress modules dependencies

* Mon Nov 29 2004 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.5
- Removed non-packaging changes - see ChangeLog instead

* Wed Sep 29 2004 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.4

* Sat Jun 26 2004 Paul Chitescu <paulc-devel@null.ro>
- Version 0.8.3

* Sat May 15 2004 Paul Chitescu <paulc-devel@null.ro>
- Added pkgconfig support

* Sun Apr 04 2004 Paul Chitescu <paulc-devel@null.ro>
- Added yate-config to the devel package

* Mon Mar 29 2004 Paul Chitescu <paulc-devel@null.ro>
- Created specfile
